#++++++++++++++++++++++++++++++++
#     Phase-plan plot           +
#++++++++++++++++++++++++++++++++

library(ggplot2)

#  1. DATA
#=============
print("", quote=FALSE)
print("", quote=FALSE)
print("===============================================", quote=FALSE)
name<-readline(prompt=" What is the file name ? : ")	
fichier<-paste(name, "txt", sep=".") 
data<-read.delim(fichier, header=TRUE)

#SEQUENCE
dt <-data[2,1]-data[1,1]
DebRang <-readline(prompt=" Start (rank): ")
DebRang<-as.numeric(DebRang)
if (DebRang == 0) {
	DebRang <- 0 ;
	FinRang <- length(data[,1])
} else {
	FinRang <- readline(prompt=" End (rank): ");
		if (FinRang == 0) {
			Lag <-readline(prompt=" Period (sec.): ");
			Lag <-as.numeric(Lag) 
			FinRang <- DebRang + Lag/dt
		} else {FinRang <- as.numeric(FinRang)}
}
print("===============================================", quote=FALSE)
t1 <- data[1,1] + DebRang*dt 		
t2 <- t1 + (FinRang - DebRang)*dt 	
P <- t2-t1 					
seq <- paste(				
	DebRang,":",FinRang,
	"(",t1,"-",t2,"s",")"
	)							 

# 2. PHASE-PLAN
#=============
x <- data[DebRang:FinRang, ]		
time<-x[,1]
V<-x[,2]
n<-length(V)
V1<-V[-n]					
V2<-V[-1]					
dt<-x[2,1]-x[1,1]				
dV<-(V2-V1)/dt				
dataF<-cbind(V1,dV)			
colnames(dataF)<-c("V","dV/dt")

#Smooth
N <- 1						
print (c("Smooth =",N), quote = FALSE)	
smooth <- readline(" New smooth value? (y/n) ")
if (smooth == "y") {
	N <- readline(" Indicate the new smooth value: ")
	N <- as.numeric(N)
} else { }
N1<-floor(N/2)									
N2<-ceiling(N/2)
j <- 1
k <- 1
initial <- 1+N1					
tailleEchant <- length(dataF[,1])-N2
Vsmooth <- c()
dVsmooth <- c()
for (i in initial:tailleEchant) {		
	k <- i-N1					
	j <- i+N2					
	Vsmooth[i] <- mean(dataF[k:j,1])	
	dVsmooth[i] <-mean(dataF[k:j,2])							
}
dataSmooth <- cbind(Vsmooth, dVsmooth)
colnames(dataSmooth)<-c("V","dV/dt")

#  3. PLOT   
#==============
dataSmooth <- as.data.frame(na.omit(dataSmooth))
info <- paste(seq,"; ","Smooth = 1 /", N)
dev.new()
Graph <- ggplot(data=dataSmooth, aes(x=dataSmooth[,1], y=dataSmooth[,2]))+		# cree un graphe dont chaque valeur de X aura une couleur differente; autres option : color, size, shape, fill 
	geom_path(linetype='solid', size = 1)+							# ligne dans l'ordre du dataframe

	labs(title=name, subtitle=info, x= "V (mV)", y = "dV/dt (mV/s)")+			# Titre et Legende							# titre et noms des axes

	theme_classic()+ 											# theme de base (pur)
	theme(axis.line.x = element_line(colour = 'black', size=1, linetype='solid'), # lignes d'axes x (aussi possible de faire des geom_line
		axis.line.y = element_line(colour = 'black', size=1, linetype='solid'), # lignes d'axes y 
		axis.ticks.length=unit(0.3,"cm"),							# ticks des 2 axes: longueur
		axis.ticks = element_line(size = 1),						# ticks des 2 axes: epaisseur 
		axis.text.x = element_text(size=15), 						# echelle x: valeurs (inclinaison texte: angle =)
		axis.text.y = element_text(size=15),						# echelle y: valeurs (inclinaison texte: angle =)							
		axis.title.x = element_text(size=20, margin = margin(10)),			# legende x: taille/position 
		axis.title.y = element_text(size=20, margin = margin(,20)),			# legende y: taille/position
		plot.title=element_text(size=15, face="plain", color="red") 		# titre: format d'ecriture
	)
print(Graph)

